---
title: Paragraphs and line breaks · Cloudflare Style Guide
description: To start a new paragraph, leave an empty line (with no spaces)
  before adding the new paragraph content.
lastUpdated: 2025-06-02T09:00:55.000Z
chatbotDeprioritize: true
source_url:
  html: https://developers.cloudflare.com/style-guide/formatting/structure/paragraphs-and-line-breaks/
  md: https://developers.cloudflare.com/style-guide/formatting/structure/paragraphs-and-line-breaks/index.md
---

## Paragraphs in Markdown

To start a new paragraph, leave an empty line (with no spaces) before adding the new paragraph content.

```txt
This sentence is the first one in this paragraph.
This second sentence also belongs to the first paragraph.


This is the first sentence of the second paragraph.
```

## Line breaks in Markdown

Avoid line breaks when possible. Considering creating a separate paragraph, even inside numbered lists.

If you need to add a line break, use the `<br/>` HTML element.

Example inside a table:

```txt
| Feature                          | Enabled |
|----------------------------------|---------|
| Feature name<br/>Additional info | Yes     |
```

This is how the table looks:

| Feature | Enabled |
| - | - |
| Feature name Additional info | Yes |

Warning

Do not use two spaces at the end of a sentence to create a forced line break. Although this Markdown syntax is supported, it is not immediately visible and can easily miss these line breaks during peer reviews.
