---
title: Update local DNS resolver · Cloudflare Learning Paths
description: With a Gateway location created, you have the ability to send
  traffic to your environment. You can test without risk by changing your DNS
  resolvers in your browser or network settings.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/learning-paths/cybersafe/gateway-onboarding/gateway-update-local-resolver/
  md: https://developers.cloudflare.com/learning-paths/cybersafe/gateway-onboarding/gateway-update-local-resolver/index.md
---

With a Gateway location created, you have the ability to send traffic to your environment. You can test without risk by changing your DNS resolvers in your browser or network settings.

## Change DNS resolver at the network level

To configure your device to send traffic to Gateway:

macOS

![macOS DNS Resolver Options](https://developers.cloudflare.com/_astro/dns-resolvers-macosx.B1GnFXfW_Z1JRXTp.webp)

Windows

![Windows DNS Resolver Options](https://developers.cloudflare.com/_astro/dns-resolvers-windows.3Ns9LR4f_Z2fwiWX.webp)

Linux

```sh
cat /etc/resolv.conf
```

```sh
nameserver 172.64.X.X
nameserver 172.64.X.X
```

iPhone

![iPhone DNS Resolver Options](https://developers.cloudflare.com/_astro/dns-resolvers-iphone.BNl5oq1v_Z2vwM4y.webp)

Android

![Android DNS Resolver Options](https://developers.cloudflare.com/_astro/dns-resolvers-android.JkoCH2BP_yhTku.webp)

## Change DNS resolver in the browser

To configure your browser to send traffic to Gateway:

1. Obtain your DNS over HTTPS (DoH) address:

   1. Go to **Gateway** > **DNS locations**.
   2. Select the default location.
   3. Copy your **DNS over HTTPS** hostname: `https://<YOUR_DOH_SUBDOMAIN>.cloudflare-gateway.com/dns-query`

2. Follow the configuration instructions for your browser:

   Mozilla Firefox

   1. In Firefox, go to **Settings**.
   2. In **Privacy & Security**, go to **DNS over HTTPS**.
   3. Under **Enable secure DNS using**, select *Max Protection*.
   4. In **Choose provider**, choose *Custom*.
   5. In the field, enter `https://<YOUR_DOH_SUBDOMAIN>.cloudflare-gateway.com/dns-query`.

   Firefox is now configured to use your DoH endpoint. For more information on configuring DoH settings in Firefox, refer to [Mozilla's documentation](https://support.mozilla.org/kb/dns-over-https).

   Note

   If you want to enforce DNS policies through WARP instead of over DoH, you can disable DoH for your organization by blocking the [Firefox DoH canary domain](https://support.mozilla.org/kb/canary-domain-use-application-dnsnet).

   Google Chrome

   1. In Chrome, go to **Settings** > **Privacy and security** > **Security**.
   2. Scroll down and turn on **Use secure DNS**.
   3. Select **With Custom**.
   4. In the **Enter custom provider** field, enter `https://<YOUR_DOH_SUBDOMAIN>.cloudflare-gateway.com/dns-query`.

   Read more about [enabling DNS over HTTPS](https://www.chromium.org/developers/dns-over-https) on Chrome.

   Microsoft Edge

   1. In Microsoft Edge, go to **Settings**.
   2. Select **Privacy, Search, and Services**, and scroll down to **Security**.
   3. Turn on **Use secure DNS**.
   4. Select **Choose a service provider**.
   5. In the **Enter custom provider** field, enter `https://<YOUR_DOH_SUBDOMAIN>.cloudflare-gateway.com/dns-query`.

   Brave

   1. In Brave, go to **Settings** > **Security and Privacy** > **Security**.
   2. Turn on **Use secure DNS**.
   3. Select **With Custom**.
   4. In the **Enter custom provider** field, enter `https://<YOUR_DOH_SUBDOMAIN>.cloudflare-gateway.com/dns-query`.

   Safari

   Currently, Safari does not support DNS over HTTPS.

3. Verify that third-party firewall or TLS decryption software does not inspect or block traffic to the DoH endpoint: `https://<YOUR_DOH_SUBDOMAIN>.cloudflare-gateway.com/dns-query`.

## More locations

To configure your router or OS, or to add additional DNS endpoints, refer to [DNS locations](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/agentless/dns/locations/).
