---
title: Signed agents · Cloudflare bot solutions docs
description: A signed agent is controlled by an end user and a verified
  signature-agent from their Web Bot Auth implementation.
lastUpdated: 2025-08-27T23:23:49.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/concepts/bot/signed-agents/
  md: https://developers.cloudflare.com/bots/concepts/bot/signed-agents/index.md
---

A signed agent is controlled by an end user and a verified signature-agent from their Web Bot Auth implementation.

You can request for your agent to be added to Cloudflare's bots and agents directory by filling out an [online application](https://dash.cloudflare.com/?to=/:account/configurations/verified-bots) in the Cloudflare dashboard.

Note

A bot cannot be registered as both a verified bot and a signed agent. Review Cloudflare's [verified bots](https://developers.cloudflare.com/bots/concepts/bot/verified-bots/) to determine how to identify your bot.

## Signed agent requirement

For an agent to be recognized, it must meet the following requirements:

1. The agent must follow the [signed agents policy](https://developers.cloudflare.com/bots/concepts/bot/signed-agents/policy/).
2. The bot must be using [Web Bot Auth](https://developers.cloudflare.com/bots/reference/bot-verification/web-bot-auth/).

Once Cloudflare approves a signed agent, it should appear on [Cloudflare Radar's bots and agents directory](https://radar.cloudflare.com/verified-bots).

***

## Transient false negatives

Once Cloudflare lists an agent as a signed agent, this entry is cached and may get delisted if no traffic is seen in the Cloudflare network coming from the agent for a defined period of time.

An agent can remain unlisted until Cloudflare sees traffic being sourced from the agent. When the agent is revalidated, it is listed as a signed agent again.

***

## Verification method

The bot must be verified using [Web Bot Auth](https://developers.cloudflare.com/bots/reference/bot-verification/web-bot-auth/).
